<?PHP 
	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1>/direct/validate - GET</h1>
				<p>The validate web service allows authorized applications to check if a Direct address is a trusted recipient and can be accessed by sending a GET request to /direct/validate. Below are some code examples for sending a message using the validate web service.</p>
				<h3>Java</h3>
				<p>
					<?php 
			require_once '/application/third_party/luminous/luminous.php'; 
			echo luminous::highlight('java', 'import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
 
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
 
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
 
import java.text.SimpleDateFormat;
 
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
 
 
public class VLERDirectTest {
 
    private String makeRequest(String urlloc) {
        String pubkey ="8f5f968d19047f8d8614338d7e10b550022f858d49215195e6320640c31b42eb";
        String prvkey ="acbb607d9ca14d16ba5e916b1acc92b6995848690b0ea6c0ad375f59298b8a56";
        String rtc = "";
        HttpURLConnection conn = null;
       
        try {
            System.out.println("urlloc>>"+urlloc+"<<");
            URL url = new URL(urlloc);
            conn = (HttpURLConnection)url.openConnection();
 
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String address = "swilliams@example.com";
	    String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
            String reqstr = "GET\n" + dstr + "\n/direct/validate/format/json?address=" + encaddr;
            System.out.println("reqest str>>" + reqstr + "<<");
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(prvkey.getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
 
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            System.out.println("encoded request str>>" + encsha + "<<");
            String auth = "DAAS " + pubkey + ":" + encsha;
            System.out.println("auth>>" + auth + "<<");
 
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("X-DaaS-Date", dstr);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestMethod("GET");
 
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
 
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
 
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
                System.err.println(output);
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
 
    public static void main(String[] args) {
        VLERDirectTest test = new VLERDirectTest();
        String address = "swilliams@example.com";
	String encaddr = new sun.misc.BASE64Encoder().encode(address.getBytes());
		     System.out.println(test.makeRequest("https://api.demo.careinbox.com/direct/validate/format/json?address=" + encaddr));
    }
 
}
');
		?>
				</p>
				<h3>HTML and JavaScript</h3>
				<p>
					<?php 
						echo luminous::highlight('php', '<html>
	<head>
		<title><?PHP echo $title; ?></title>
		<LINK href="/css/example.css" rel="stylesheet" type="text/css">
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui-1.8.18.custom.css" />
		<script type="text/javascript" src="/js/jquery.min.js"></script>
		<script type="text/javascript" src="/js/jquery-ui-1.8.17.custom.min.js"></script>
		<script type="text/javascript" src="/js/jquery.form.js"></script>
		<script type="text/javascript" src="/js/rollups/hmac-sha256.js"></script>
		<script type="text/javascript" src="/js/components/enc-base64-min.js"></script>
		<script type="text/javascript" src="/js/date.format.js"></script>
		<script type="text/javascript">	

			var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

			//a function for base64 encoding an input string
			function encode64(input) {
			   if (!String(input).length) return false;
			   var output = "";
			   var chr1, chr2, chr3;
			   var enc1, enc2, enc3, enc4;
			   var i = 0;
	
			   do {
			      chr1 = input.charCodeAt(i++);
			      chr2 = input.charCodeAt(i++);
			      chr3 = input.charCodeAt(i++);
	
			      enc1 = chr1 >> 2;
			      enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			      enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			      enc4 = chr3 & 63;
	
			      if (isNaN(chr2)) {
			         enc3 = enc4 = 64;
			      } else if (isNaN(chr3)) {
			         enc4 = 64;
			      }
	
			      output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + 
			         keyStr.charAt(enc3) + keyStr.charAt(enc4);
			   } while (i < input.length);
			   
			   return output;
			}
		
			$(function() {
				$(".json").click(function() {
					$("#sender").css("background-color","#fff");
					$("#to").css("background-color","#fff");
					var oldVal = $(\'#address\').val();
					$(\'#address\').val(encode64(""+$(\'#address\').val())); 
					$("#messageForm").ajaxSubmit({  
						type: "GET",  
					  	url: "/direct/validate/format/json",
					  	beforeSend: function(request){
							start = new Date().getTime();
							//use this block if you want to send UTC stamp
							/*var d = Date.now();
							var currentDate = Math.round(d / 1000);*/
							//use this block if you want to send normal timestamp with timezone
							var d = new Date();
							var currentDate = d.format("mm/dd/yyyy HH:MM:ss Z");
							var hash_string = "GET\n"+currentDate+"\n/direct/validate/format/json?address="+encodeURIComponent($(\'#address\').val()).replace(/%20/g,"+");
							var hashString = CryptoJS.HmacSHA256(hash_string,"947d0e7ada02a75f2643fa409f19e976b235db5e86b93b292697d980ba177206");
							var base64 = encode64(""+hashString);
							var authorization = "DAAS 323716a85b68f3f1ef7595900c00f5d6e395fad9e88537589a43a688904c511e:"+base64;
							request.setRequestHeader("Authorization", authorization);
							request.setRequestHeader("X-Daas-Date", currentDate);
						  }, 
					  	success: function(data, status, jqXHR) {
						  	if (data[\'message\'])
					  			$(\'#success\').html(data[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else 
								$(\'#success\').html("Valid address string.").slideDown(500).delay(5000).slideUp(500);

							$(\'#address\').val(oldVal);
					  	},
					  	error: function (jqXHR, textStatus, errorThrown) {
					  		if ($.parseJSON(jqXHR.responseText)[\'message\'])
					  			$(\'#error\').html($.parseJSON(jqXHR.responseText)[\'message\']).slideDown(500).delay(5000).slideUp(500);
						  	else 
								$(\'#error\').html("Not a valid address string.").slideDown(500).delay(5000).slideUp(500);

					  		$(\'#address\').val(oldVal);
					  	}
					});
				});
			});
		</script>
	</head>
	<body>
		<div class="container">
			<h1>Direct Mail</h1>
			<div id="success">Valid address string.</div>
			<div id="error"><div class="imageText">Not a valid address string.</div></div>
			<div class="wrapper">
				<form id="messageForm" action="/direct/validate" method="GET">
					<label>Address:</label> <input class="full" type="text" name="address" id="address">
				</form>
				<br/>
			</div>
			<div class="button-container"><input type="button" class="button json" value="Send"></div>
		</div>
	</body>
</html>');
					?>
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>